rem **********************************************************************
rem ** This batch file will run right after ReadyToInstall is done
rem **
rem ** View the output file \RunReadyToInstallLog.txt for details
rem **
rem **
rem **********************************************************************
@echo off

set LogFile="RunReadyToInstallLog.txt"
if exist %LogFile% del %LogFile%
echo View the output file %LogFile% for details

set serveraction=/regserver
set /a fileNotFoundCount=0
set /a errorCount=0
set /a skippedCount=0
set failedFiles=
set missingFiles=
set registeredCount=0


rem **** REGISTER FILES ****
for %%f in ( ^
SetRBMModelName.reg
) do call :RegisterObject %%f


rem **** REPORT ANY ERRORS ****
if NOT "%fileNotFoundCount%"=="0" echo MISSING FILES
if NOT "%errorCount%"=="0" echo FAILED REGISTRATION
if NOT "%skippedCount%"=="0" echo SKIPPED REGISTRATION

rem **** REPORT TOTAL REGISTERED ****
echo.>> %Logfile%
echo Did something for %registeredCount% files >> %Logfile%
echo Did something for %registeredCount% files

goto :eof

:eof
exit

rem ******************************************************************
rem
rem  RegisterObject Subroutine
rem  Description: Registers various file types and while checking
rem               return codes and logging status
rem
rem ******************************************************************
:RegisterObject

rem *** Log if the file does not exist
if NOT EXIST %1  goto FileNotFound

rem ******************* REG Files **************************************************
if /i NOT %~x1==.reg goto NotREG
echo Registering file %1 >> %Logfile%
regedit /S %1 >> %Logfile%  2>&1
goto CheckErrorlevel

:NotREG

rem ******************* BAT Files **************************************************
rem **** if it is a batch file then run it with supplied arguments and check errocode  ****
if /i NOT %~x1==.bat goto NotBAT
echo executing batch file %1 %2 %3 %4 >> %Logfile%
call %1 %2 %3 %4 >> %Logfile%  2>&1
goto CheckErrorlevel

:NotBAT

rem ******************* EXE Files **************************************************
rem **** if it is executable then run it with supplied arguments and check errocode  ****
if /i NOT %~x1==.exe goto NotEXE

echo Registering executable %1 %serveraction% >> %Logfile%
%1 %serveraction%
goto CheckErrorlevel

:NotEXE

rem ******************* TLB Files **************************************************
rem **** if it is a typelib then register the typelib and check errocode *******
if /i NOT %~x1==.tlb goto NotTLB

rem TLB registration is not necessary for the build process, but it is for running a retail based
rem application on a deployed system.
echo Registering typelib %1 >> %Logfile%
regtlib -q %1  >> %Logfile%  2>&1
goto CheckErrorlevel

:NotTLB

rem ******************* DLL,OCX Files **************************************************
rem **** everything else : dll,ocx gets here, use regsvr32 and check errocode *****

echo regsvr32 %1  >> %Logfile%
regsvr32 /s %1 >> %Logfile%  2>&1

:CheckErrorlevel
rem check and report the error code returned by the last operation
if ERRORLEVEL 1 goto BadErrorlevel
set /a registeredCount=%registeredCount% + 1
goto endsubroutine

rem ************** Begin error handlers ******************

:FileNotFound
echo *** ERROR: %1 File not found>> %Logfile%
set /a fileNotFoundCount=%fileNotFoundCount% + 1
goto endsubroutine

:SkipThis
echo *** SKIPPING: %1 >> %Logfile%
set /a skippedCount=%skippedCount% + 1
goto endsubroutine

:BadErrorlevel
echo *** ERROR: Action for %1 %2 %3 %4  Failed, ERRORLEVEL = %ERRORLEVEL%  >> %Logfile%
:ErrorDetected
set /a errorCount=%errorCount% + 1

:endsubroutine









