' Script name : IsKpkSystem.vbs
' Purpose     : Determine if a system is a KPK or an APEX system. 
'               This script will look for an SCM board, if it finds 
'               one it reports that the system is a KPK system, otherwise
'               it will report the system as an APEX. The script will test
'               for an SCM board by lookiing for 2 USB mass storage devices 
'               (Vid_04e6&Pid_0c04, Vid_04e6&Pid_0c05). A more complete test
'               would be to verify that the two mass storage device share the
'               same parent hub with Vid_0409&Pid_0050.
'
'               Return codes:	
'					1 = error
'					2 = KPK
'					3 = APEX
'

option explicit
on error resume next

dim returnCode
dim SPDRP_HARDWAREID
dim diObj
dim infoSet
dim infoDev
dim MSD_HARDWARE_ID1
dim MSD_HARDWARE_ID2
dim hardwareID
dim hardwareIDArray
dim size
dim i
dim j
dim foundMsd1
dim foundMsd2

	
	' wscript.echo "IsKpkSystem.vbs"

	returnCode = 1
	SPDRP_DEVICEDESC = 0
	SPDRP_HARDWAREID = 1
	MSD_HARDWARE_ID1 = "USB\Vid_04e6&Pid_0c04"
	MSD_HARDWARE_ID2 = "USB\Vid_04e6&Pid_0c05"
	foundMsd1 = false
	foundMsd2 = false
	
	err.number = 0
	set diObj = CreateObject( "DeviceInstallCtrl.DeviceInstall" )
	if err.number <> 0 then
		wscript.echo "error: cannot create DeviceInstallCtrl.DeviceInstall"
		wscript.quit returnCode
	end If	
	
	' Look for USB devices that are present on the system
	set infoSet = diObj.CreateClassDeviceInfoSet("", "USB", true)	
	size = infoSet.size
	' wscript.echo "Found " & size & " USB devices"
	
	' For each device, get it's hardware ID and compare it to each of the SCM Mass Storage device hardware id's
	'
	for i = 0 to size - 1
		set infoDev = infoSet.GetDevice(i)
		hardwareID = ""
		hardwareID = infoDev.GetDeviceRegistryProperty (SPDRP_HARDWAREID)
		hardwareIDArray = Split(hardwareID, Chr(0), -1, 0)	' binary compare
		for j = LBound(hardwareIDArray) To UBound(hardwareIDArray)
			if hardwareIDArray(j) = MSD_HARDWARE_ID1 Then				
				' wscript.echo "Found device: " + hardwareID	
				foundMsd1 = true				
			End if
			if hardwareIDArray(j) = MSD_HARDWARE_ID2 Then				
				' wscript.echo "Found device: " + hardwareID	
				foundMsd2 = true				
			End if			
		Next
	Next

	diObj.DestroyDeviceInfoSet infoSet	
	
	if foundMsd1 and foundMsd2 then
		returnCode = 2
	else
		returnCode = 3
	end if
		
	
	
wscript.quit returnCode	